#!/bin/bash
if [ -f "LPS_setup_date.txt" ]
then
    rundate=$(<LPS_setup_date.txt)
    echo "I think you've already set up the Vaunix LPS support"
    echo "for Python3. I think so because I see a file called"
    echo "'LPS_setup_date.txt' that says this was run"
    echo "on $rundate. If you want to run it"
    echo "again, that's fine. Just delete 'LPS_setup_date.txt'"
    echo "and we should be good to go."
else
    # Let's remember that we've already done this
    date > LPS_setup_date.txt
    # Get the basic building tools if they aren't here already
    sudo apt-get install -y build-essential
    # We probably already have Python 3, but we'll make sure
    sudo apt-get install -y python3
    sudo apt-get upgrade -y python3
    # And get the dev tools for it
    sudo apt-get install -y python3.6-dev
    # This is the USB library
	sudo apt-get install libusb-1.0-0-dev
    # Make sure that whole machine has the latest of everything. Uncomment if you like.
    #sudo apt-get upgrade

    # Install the LPS Python extension and upgrade it if necessary
    sudo pip3 install . --upgrade

    #
    # Alternatively you can play with the test program interactively
    #   in IDLE. Once it starts, use File->Open to open 'LPS_test.py'
    #sudo idle3
    echo "Don't forget to use 'sudo' when you run Python."
    echo "'sudo python3 LPS_test.py' runs the sample test program."
    echo "'sudo idle3' brings up the interactive IDLE environment."
fi
